
/*            This is Rom.Type.Inc         */

/*************************************************************************

The data structures are setup as follows:

1)  There is a queue of input files of type FileType.
     - the conn field is used to store the OMF part of the file
     - pSegNames represents a linked list of segments that are executed
       from this file
2)  Each segment that is executed is of type SegNamesType.
     - pSegName points to the segment name
     - segLength represents the segment length (from the load table)
     - sLName is a selector that points to the LNames Queue
3)  For each file that is sent through the loader, a LNames Queue is maintained.
     - pName is the LNames name.
     - conn is a file conn that has the executable code if the Lname represents 
       a segment that is executable.
     - conversion represents whether the segment is to be executed or not.

*************************************************************************/


  /*             Constants         */


  DCL OMF                LIT '0';
  DCL codeOnly           LIT '1';
  DCL romHere            LIT '0BB66H';
  DCL romHeaderSize      LIT '16';
  DCL dirOffsetLoc       LIT '6';
  DCL pageZeroLoc        LIT '12';
  DCL dirLengthLoc       LIT '8';
  DCL lLogPageSize       LIT '252';
  DCL lPageSize          LIT '256';
  DCL lRealPageSize      LIT '256';
  DCL lRealParaSize      LIT '16';

/*
  DCL numSectorsPerRom   LIT '512';
  DCL bankIncrement      LIT '2000h';
  DCL initialBank        LIT '8000h';
  DCL sRomHeader         LIT '9ff0h';
*/
  DCL romHeaderOffset    LIT '1FF0H';

  DCL systemSize         LIT '24';  
  DCL segTblEntrySize    LIT '10';    
  DCL grpTblEntrySize    LIT '8';    
  DCL maxSymLen          LIT '40';   

  /*      OMF Record types     */

  DCL rHeadr             LIT '6EH';
  DCL regInt             LIT '70H';
  DCL reData             LIT '72H';
  DCL riData             LIT '74H';
  DCL ovlDef             LIT '76H';
  DCL endRec             LIT '78H';
  DCL tHeadr             LIT '80H';
  DCL lHeadr             LIT '82H';
  DCL peData             LIT '84H';
  DCL piData             LIT '86H';
  DCL modEnd             LIT '8AH';
  DCL fixUpp             LIT '9CH';

  DCL found              LIT '0ffffh';
  DCL notFound           LIT '0';


  /*            Types           */

  DCL ArgumentType LIT 'STRUCTURE
    (length         BYTE,
     chars (255)    BYTE)';

  DCL FileType     LIT 'STRUCTURE
    (checksum       WORD,
     next           SELECTOR,
     prev           SELECTOR,
     pName          PTR,
     visibleFile    BOOLEAN,
     conn           WORD,
     pSegNames      PTR,
     executing      BOOLEAN)';

  DCL SegNamesType LIT 'STRUCTURE
    (pNext          PTR,
     pName          PTR,
     sLName         EidType,
     segLength      WORD,
     pOutName       PTR)';


  DCL RomHeaderInfo LIT
    'romHereFlag      WORD,
     systemIndicator  BYTE,
     systemRom        BYTE,
     bootSector       WORD,
     romAddr          BYTE,
     romSize          BYTE,
     numWaitStates    BYTE';

/* bootSector is really a SELECTOR */

  DCL MoreRomHeaderInfo LIT
    'dirSelector      WORD,
     dirLength        WORD,
     numFiles         WORD,
     pageZeroSelector WORD,
     numPages         WORD,
     romId            WORD';

  DCL EvenMoreRomHeaderInfo LIT
    'copyRight (45)   BYTE,
     time (11)        BYTE,
     partNumber (9)   BYTE,
     partName (15)    BYTE,
     bootMsgLength    BYTE,
     bootMessage (30) BYTE,
     bootId           BYTE';

  DCL EvenEvenMoreRomHeaderInfo LIT
    'numRomsInPkg     BYTE,
     romValue (4)     WORD,
     invisibleInfo (20) WORD,
     unused (62)      BYTE,
     numRomsInGroup   BYTE,
     groupId (8)      BYTE,
     groupSequenceId  BYTE,
     patchCode        BYTE,
     checksum         BYTE';

  DCL RomHeaderType LIT 'STRUCTURE
    (RomHeaderInfo,
     MoreRomHeaderInfo,
     EvenMoreRomHeaderInfo,
     EvenEvenMoreRomHeaderInfo)';

  DCL MiniRomHeaderType LIT 'STRUCTURE
    (dirLength    WORD,
     numFiles     WORD,
     numPages     WORD,
     romID        WORD)';

  DCL RomDirEntryType LIT 'STRUCTURE
    (fid          WORD,
     length       BYTE,
     name (1)     BYTE)';
  
  DCL LNamesType     LIT 'STRUCTURE
    (checksum       WORD,
     next           SELECTOR,
     prev           SELECTOR,
     pName          PTR,
     conn           WORD,
     conversion     BYTE)';

  DCL AddressType LIT 'STRUCTURE
    (offset WORD,
     base   WORD)';

  DCL SegTableType LIT 'STRUCTURE
    (offset     WORD,
     base       WORD,
     segLength  WORD,
     LNameIndex WORD,
     sRomBase   WORD)';

  DCL GrpTableType LIT 'STRUCTURE
    (base       WORD,
     segLength  WORD,
     LNameIndex WORD,
     sRomBase   WORD)';
 
  DCL WordType LIT 'STRUCTURE
    (low  BYTE,
     high BYTE)';

  DCL SymNameType LIT 'STRUCTURE
    (length            BYTE,
     chars (maxSymLen) BYTE)';


